/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.gui;

import com.google.common.collect.Lists;
import com.raoulvdberge.refinedstorage.RS;
import com.raoulvdberge.refinedstorage.api.autocrafting.preview.ICraftingPreviewElement;
import com.raoulvdberge.refinedstorage.api.render.IElementDrawer;
import com.raoulvdberge.refinedstorage.api.render.IElementDrawers;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.preview.CraftingPreviewElementError;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.preview.CraftingPreviewElementFluidStack;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.preview.CraftingPreviewElementItemStack;
import com.raoulvdberge.refinedstorage.gui.GuiBase;
import com.raoulvdberge.refinedstorage.gui.control.Scrollbar;
import com.raoulvdberge.refinedstorage.network.MessageCraftingCancel;
import com.raoulvdberge.refinedstorage.network.MessageGridCraftingStart;
import com.raoulvdberge.refinedstorage.util.RenderUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class GuiCraftingPreview
extends GuiBase {
    private static final int VISIBLE_ROWS = 5;
    private final List<ICraftingPreviewElement<?>> stacks;
    private final GuiScreen parent;
    private final UUID craftingTaskId;
    private final int quantity;
    private final long calculationTime;
    private GuiButton startButton;
    private GuiButton cancelButton;
    private CraftingPreviewElementItemStack hoveringStack;
    private CraftingPreviewElementFluidStack hoveringFluid;
    private final IElementDrawers drawers = new CraftingPreviewElementDrawers();
    private final boolean fluids;

    public GuiCraftingPreview(GuiScreen parent, List<ICraftingPreviewElement<?>> stacks, UUID craftingTaskId, long calculationTime, int quantity, boolean fluids) {
        super(new Container(){

            public boolean func_75145_c(@Nonnull EntityPlayer player) {
                return false;
            }
        }, 254, 201);
        this.stacks = new ArrayList(stacks);
        this.parent = parent;
        this.craftingTaskId = craftingTaskId;
        this.quantity = quantity;
        this.calculationTime = calculationTime;
        this.fluids = fluids;
        this.scrollbar = new Scrollbar(235, 20, 12, 149);
    }

    @Override
    public void init(int x, int y) {
        this.cancelButton = this.addButton(x + 55, y + 201 - 20 - 7, 50, 20, GuiCraftingPreview.t("gui.cancel", new Object[0]));
        this.startButton = this.addButton(x + 129, y + 201 - 20 - 7, 50, 20, GuiCraftingPreview.t("misc.refinedstorage:start", new Object[0]));
        this.startButton.field_146124_l = this.stacks.stream().noneMatch(ICraftingPreviewElement::hasMissing) && !this.hasError();
    }

    @Override
    public void update(int x, int y) {
        if (this.scrollbar != null) {
            this.scrollbar.setEnabled(this.getRows() > 5);
            this.scrollbar.setMaxOffset(this.getRows() - 5);
        }
    }

    private boolean hasError() {
        return this.stacks.size() == 1 && this.stacks.get(0) instanceof CraftingPreviewElementError;
    }

    @Override
    public void drawBackground(int x, int y, int mouseX, int mouseY) {
        this.bindTexture("gui/crafting_preview.png");
        this.drawTexture(x, y, 0, 0, this.screenWidth, this.screenHeight);
        if (this.hasError()) {
            GuiCraftingPreview.func_73734_a((int)(x + 7), (int)(y + 20), (int)(x + 228), (int)(y + 169), (int)-2368549);
        }
    }

    @Override
    public void drawForeground(int mouseX, int mouseY) {
        float scale;
        this.drawString(7, 7, GuiCraftingPreview.t("gui.refinedstorage:crafting_preview", new Object[0]));
        float f = scale = this.field_146289_q.func_82883_a() ? 1.0f : 0.5f;
        if (this.calculationTime != -1L) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179152_a((float)scale, (float)scale, (float)1.0f);
            this.drawString(RenderUtils.getOffsetOnScale(7, 0.5f), RenderUtils.getOffsetOnScale(175, 0.5f), GuiCraftingPreview.t("gui.refinedstorage:crafting_preview.calculation_time", new Object[0]) + " " + TextFormatting.DARK_GREEN + this.calculationTime + "ms");
            GlStateManager.func_179121_F();
        }
        int x = 7;
        int y = 15;
        if (this.hasError()) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179152_a((float)scale, (float)scale, (float)1.0f);
            this.drawString(RenderUtils.getOffsetOnScale(x + 5, scale), RenderUtils.getOffsetOnScale(y + 11, scale), GuiCraftingPreview.t("gui.refinedstorage:crafting_preview.error", new Object[0]));
            this.drawString(RenderUtils.getOffsetOnScale(x + 5, scale), RenderUtils.getOffsetOnScale(y + 21, scale), GuiCraftingPreview.t("gui.refinedstorage:crafting_preview.error.too_complex.0", new Object[0]));
            this.drawString(RenderUtils.getOffsetOnScale(x + 5, scale), RenderUtils.getOffsetOnScale(y + 31, scale), GuiCraftingPreview.t("gui.refinedstorage:crafting_preview.error.too_complex.1", new Object[0]));
            GlStateManager.func_179121_F();
        } else {
            int slot = this.scrollbar != null ? this.scrollbar.getOffset() * 3 : 0;
            RenderHelper.func_74520_c();
            GlStateManager.func_179126_j();
            this.hoveringStack = null;
            this.hoveringFluid = null;
            for (int i = 0; i < 15; ++i) {
                if (slot < this.stacks.size()) {
                    ICraftingPreviewElement<?> stack = this.stacks.get(slot);
                    stack.draw(x, y + 5, this.drawers);
                    if (this.inBounds(x + 5, y + 7, 16, 16, mouseX, mouseY)) {
                        CraftingPreviewElementItemStack craftingPreviewElementItemStack = this.hoveringStack = stack.getId().equals("item_renderer") ? (CraftingPreviewElementItemStack)stack : null;
                        if (this.hoveringStack == null) {
                            CraftingPreviewElementFluidStack craftingPreviewElementFluidStack = this.hoveringFluid = stack.getId().equals("fluid_renderer") ? (CraftingPreviewElementFluidStack)stack : null;
                        }
                    }
                }
                if ((i + 1) % 3 == 0) {
                    x = 7;
                    y += 30;
                } else {
                    x += 74;
                }
                ++slot;
            }
        }
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        if (this.hoveringStack != null) {
            List textLines = this.hoveringStack.getElement().func_82840_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, (ITooltipFlag)(Minecraft.func_71410_x().field_71474_y.field_82882_x ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL));
            ArrayList smallTextLines = Lists.newArrayList((Object[])new String[]{GuiCraftingPreview.t(this.hoveringStack.hasMissing() ? "gui.refinedstorage:crafting_preview.missing" : "gui.refinedstorage:crafting_preview.to_craft", this.hoveringStack.getToCraft()), GuiCraftingPreview.t("gui.refinedstorage:crafting_preview.available", this.hoveringStack.getAvailable())});
            RenderUtils.drawTooltipWithSmallText(textLines, smallTextLines, RS.INSTANCE.config.detailedTooltip, this.hoveringStack.getElement(), mouseX, mouseY, this.screenWidth, this.screenHeight, this.field_146289_q);
        } else if (this.hoveringFluid != null) {
            ArrayList textLines = Lists.newArrayList((Object[])new String[]{this.hoveringFluid.getElement().getLocalizedName()});
            ArrayList smallTextLines = Lists.newArrayList((Object[])new String[]{GuiCraftingPreview.t(this.hoveringFluid.hasMissing() ? "gui.refinedstorage:crafting_preview.missing" : "gui.refinedstorage:crafting_preview.to_craft", this.hoveringFluid.getToCraft()), GuiCraftingPreview.t("gui.refinedstorage:crafting_preview.available", this.hoveringFluid.getAvailable())});
            RenderUtils.drawTooltipWithSmallText(textLines, smallTextLines, RS.INSTANCE.config.detailedTooltip, ItemStack.field_190927_a, mouseX, mouseY, this.screenWidth, this.screenHeight, this.field_146289_q);
        }
    }

    protected void func_73869_a(char character, int keyCode) throws IOException {
        if (keyCode == 28 && this.startButton.field_146124_l) {
            this.startRequest();
        } else if (keyCode == 1) {
            this.close();
        } else {
            super.func_73869_a(character, keyCode);
        }
    }

    @Override
    protected void func_146284_a(@Nonnull GuiButton button) throws IOException {
        super.func_146284_a(button);
        if (button.field_146127_k == this.startButton.field_146127_k) {
            this.startRequest();
        } else if (button.field_146127_k == this.cancelButton.field_146127_k) {
            this.close();
        }
    }

    private void startRequest() {
        RS.INSTANCE.network.sendToServer((IMessage)new MessageGridCraftingStart(this.craftingTaskId, this.quantity, this.fluids));
        FMLClientHandler.instance().showGuiScreen((Object)this.parent);
    }

    private int getRows() {
        return Math.max(0, (int)Math.ceil((float)this.stacks.size() / 3.0f));
    }

    private void close() {
        if (this.startButton.field_146124_l) {
            RS.INSTANCE.network.sendToServer((IMessage)new MessageCraftingCancel(this.craftingTaskId));
        }
        FMLClientHandler.instance().showGuiScreen((Object)this.parent);
    }

    public class CraftingPreviewElementDrawers
    extends GuiBase.ElementDrawers {
        private final IElementDrawer<Integer> overlayDrawer = (x, y, colour) -> {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179140_f();
            Gui.func_73734_a((int)x, (int)y, (int)(x + 73), (int)(y + 29), (int)colour);
        };

        @Override
        public IElementDrawer<Integer> getOverlayDrawer() {
            return this.overlayDrawer;
        }
    }
}

